<?php
/**
 * Author Twitter (child) block.
 * This block is only available as a child
 * block within the parent Author Info block.
 */

// Grab our ACF field.
$twitter_handle = get_field( 'twitter' );
?>

<?php if ( $is_preview && empty( $twitter_handle ) ) : ?>
	<p>Please enter a Twitter handle.</p>
<?php else : ?>
	<p>
		<svg height="0.95rem" width="0.95rem" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" class="icon icon-twitter" viewBox="0 0 24 24"><path d="M22 4s-.7 2.1-2 3.4c1.6 10-9.4 17.3-18 11.6 2.2.1 4.4-.6 6-2C3 15.5.5 9.6 3 5c2.2 2.6 5.6 4.1 9 4-.9-4.2 4-6.6 7-3.8 1.1 0 3-1.2 3-1.2z"/></svg>
		<a href="https://twitter.com/<?php echo esc_html( $twitter_handle ); ?>">
			@<?php echo esc_html( $twitter_handle ); ?>
		</a>
	</p>
<?php endif; ?>
